Attribute VB_Name = "Module1"
' Copyright (C) 2001 Agilent Technologies Company
' VXIplug&play Instrument Driver for the age8481a

'------------------------------------------------------------------------------

' Global Constants

'------------------------------------------------------------------------------

'  Returned error status values
'  Agilent Common Error numbers start at BFFC0D00

Global Const age8481a_INSTR_ERROR_NOT_VXI = &HBFFC0D00

' D01 unused

Global Const age8481a_INSTR_ERROR_NULL_PTR = &HBFFC0D02

Global Const age8481a_INSTR_ERROR_RESET_FAILED = &HBFFC0D03

Global Const age8481a_INSTR_ERROR_UNEXPECTED = &HBFFC0D04

Global Const age8481a_INSTR_ERROR_INV_SESSION = &HBFFC0D05

Global Const age8481a_INSTR_ERROR_LOOKUP = &HBFFC0D06

Global Const age8481a_INSTR_ERROR_DETECTED = &HBFFC0D07


' Used by Status System Functions

Global Const age8481a_USER_ERROR_HANDLER = -1

Global Const age8481a_STB_MAV = 5

Global Const age8481a_ESR_OPC = 601
Global Const age8481a_ESR_QUERY_ERROR = 603
Global Const age8481a_ESR_DEVICE_DEPENDENT_ERROR = 604
Global Const age8481a_ESR_EXECUTION_ERROR = 605
Global Const age8481a_ESR_COMMAND_ERROR = 606

Global Const age8481a_OPER_SCAN_DONE = 809

'   Used by Function age8481a_timeOut
Global Const age8481a_TIMEOUT_MAX = 2147483647
Global Const age8481a_TIMEOUT_MIN = 0
Global Const age8481a_INTERRUPT_LINE_MAX = 7
Global Const age8481a_INTERRUPT_LINE_MIN = 0

'* Instrument Specific Constants

'******   Used by Function age8481a_armCoun   *****/
Global Const age8481a_ARM_COUN_MAX = 32767
Global Const age8481a_ARM_COUN_MIN = 1

'******   Used by Function age8481a_closRowCol16x16   *****/
Global Const age8481a_CARD_MAX = 99
Global Const age8481a_CARD_MIN = 1
Global Const age8481a_ROW_MIN = 0
Global Const age8481a_COL_MIN = 0
Global Const age8481a_PATTERN_MAX = 510
Global Const age8481a_PATTERN_MIN = 0

'******   Used by Function age8481a_closRowCol4x32   *****/
'*  age8481a_CARD_MAX  */
'*  age8481a_CARD_MIN  */
Global Const age8481a_ROW_MAX = 3
'*  age8481a_ROW_MIN  */
Global Const age8481a_COL_MAX = 31
'*  age8481a_COL_MIN  */

'******   Used by Function age8481a_outpEcltStat_M   *****/
Global Const age8481a_ECLTNUM_MAX = 1
Global Const age8481a_ECLTNUM_MIN = 0

'******   Used by Function age8481a_outpEcltStat_M_Q   *****/
'*  age8481a_ECLTNUM_MAX  */
'*  age8481a_ECLTNUM_MIN  */

'******   Used by Function age8481a_outpTtltStat_M   *****/
Global Const age8481a_TTLTNUM_MAX = 7
Global Const age8481a_TTLTNUM_MIN = 0

'******   Used by Function age8481a_outpTtltStat_M_Q   *****/
'*  age8481a_TTLTNUM_MAX  */
'*  age8481a_TTLTNUM_MIN  */

'******   Used by Function age8481a_routClos   *****/
Global Const age8481a_CHANNEL_MAX = 999999
Global Const age8481a_CHANNEL_MIN = 100

'******   Used by Function age8481a_routClos_Q   *****/
'*  age8481a_CHANNEL_MAX  */
'*  age8481a_CHANNEL_MIN  */

'******   Used by Function age8481a_routOpen   *****/
'*  age8481a_CHANNEL_MAX  */
'*  age8481a_CHANNEL_MIN  */

'******   Used by Function age8481a_routOpen_Q   *****/
'*  age8481a_CHANNEL_MAX  */
'*  age8481a_CHANNEL_MIN  */

'******   Used by Function age8481a_systCdes_Q   *****/
'*  age8481a_CARD_MAX  */
'*  age8481a_CARD_MIN  */

'******   Used by Function age8481a_systCpon   *****/
'*  age8481a_CARD_MAX  */
'*  age8481a_CARD_MIN  */

'******   Used by Function age8481a_systCtyp_Q   *****/
'*  age8481a_CARD_MAX  */
'*  age8481a_CARD_MIN  */

'******   Used by Function age8481a_trigSour   *****/
Global Const age8481a_TRIG_SOUR_BUS = 0
Global Const age8481a_TRIG_SOUR_ECLT0 = 1
Global Const age8481a_TRIG_SOUR_ECLT1 = 2
Global Const age8481a_TRIG_SOUR_HOLD = 3
Global Const age8481a_TRIG_SOUR_IMM = 4
Global Const age8481a_TRIG_SOUR_TTLT0 = 5
Global Const age8481a_TRIG_SOUR_TTLT1 = 6
Global Const age8481a_TRIG_SOUR_TTLT2 = 7
Global Const age8481a_TRIG_SOUR_TTLT3 = 8
Global Const age8481a_TRIG_SOUR_TTLT4 = 9
Global Const age8481a_TRIG_SOUR_TTLT5 = 10
Global Const age8481a_TRIG_SOUR_TTLT6 = 11
Global Const age8481a_TRIG_SOUR_TTLT7 = 12
Global Const age8481a_TRIG_SOUR_EXT = 13

'------------------------------------------------------------------------------

' Function Declarations

'------------------------------------------------------------------------------

' required plug and play functions from VPP-3.1

Declare Function age8481a_init Lib "age8481a_32.dll" (ByVal InstrDesc As String, ByVal id_query As Integer, ByVal do_reset As Integer, vi As Long) As Long

Declare Function age8481a_close Lib "age8481a_32.dll" (ByVal vi As Long) As Long

Declare Function age8481a_reset Lib "age8481a_32.dll" (ByVal vi As Long) As Long

Declare Function age8481a_self_test Lib "age8481a_32.dll" (ByVal vi As Long, test_result As Integer, ByVal test_message As String) As Long

Declare Function age8481a_error_query Lib "age8481a_32.dll" (ByVal vi As Long, error_number As Long, ByVal error_message As String) As Long

Declare Function age8481a_error_message Lib "age8481a_32.dll" (ByVal vi As Long, ByVal error_number As Long, ByVal message As String) As Long

Declare Function age8481a_revision_query Lib "age8481a_32.dll" (ByVal vi As Long, ByVal driver_rev As String, ByVal instr_rev As String) As Long

' Agilent other standard functions

Declare Function age8481a_dcl Lib "age8481a_32.dll" (ByVal vi As Long) As Long

Declare Function age8481a_errorQueryDetect Lib "age8481a_32.dll" (ByVal vi As Long, ByVal errorQueryDetect As Integer) As Long

Declare Function age8481a_errorQueryDetect_Q Lib "age8481a_32.dll" (ByVal vi As Long, pErrDetect As Integer) As Long

Declare Function age8481a_opc Lib "age8481a_32.dll" (ByVal vi As Long) As Long

Declare Function age8481a_opc_Q Lib "age8481a_32.dll" (ByVal vi As Long, opc As Integer) As Long

Declare Function age8481a_readStatusByte_Q Lib "age8481a_32.dll" (ByVal vi As Long, statusByte As Integer) As Long

Declare Function age8481a_operCond_Q Lib "age8481a_32.dll" (ByVal vi As Long, pCondition As Long) As Long

Declare Function age8481a_operEvent_Q Lib "age8481a_32.dll" (ByVal vi As Long, pEvent As Long) As Long

Declare Function age8481a_statEvenClr Lib "age8481a_32.dll" (ByVal vi As Long) As Long

Declare Function age8481a_statEven_Q Lib "age8481a_32.dll" (ByVal vi As Long, ByVal happening As Long, pEvent As Integer) As Long

Declare Function age8481a_timeOut Lib "age8481a_32.dll" (ByVal vi As Long, ByVal timeOut As Long) As Long

Declare Function age8481a_timeOut_Q Lib "age8481a_32.dll" (ByVal vi As Long, pTimeOut As Long) As Long

Declare Function age8481a_trg Lib "age8481a_32.dll" (ByVal vi As Long) As Long

Declare Function age8481a_wai Lib "age8481a_32.dll" (ByVal vi As Long) As Long


'------------------------------------------------------------------------------
' Instrument Specific Function Declarations
'------------------------------------------------------------------------------

Declare Function age8481a_abor Lib "age8481a_32.dll" (ByVal vi As Long) As Long

Declare Function age8481a_armCoun Lib "age8481a_32.dll" (ByVal vi As Long, ByVal armCoun As Integer) As Long

Declare Function age8481a_armCoun_Q Lib "age8481a_32.dll" (ByVal vi As Long, armCoun As Integer) As Long

Declare Function age8481a_closRowCol4x32 Lib "age8481a_32.dll" (ByVal vi As Long, ByVal card As Integer, ByVal row As Integer, ByVal col As Integer) As Long

Declare Function age8481a_initCont Lib "age8481a_32.dll" (ByVal vi As Long, ByVal initCont As Integer) As Long

Declare Function age8481a_initCont_Q Lib "age8481a_32.dll" (ByVal vi As Long, initCont As Integer) As Long

Declare Function age8481a_initImm Lib "age8481a_32.dll" (ByVal vi As Long) As Long

Declare Function age8481a_interLine Lib "age8481a_32.dll" (ByVal vi As Long, ByVal card As Integer, ByVal intLine As Integer) As Long

Declare Function age8481a_interLine_Q Lib "age8481a_32.dll" (ByVal vi As Long, ByVal card As Integer, intLine As Integer) As Long

Declare Function age8481a_interTimer Lib "age8481a_32.dll" (ByVal vi As Long, ByVal card As Integer, ByVal timerVal As Double) As Long

Declare Function age8481a_interTimer_Q Lib "age8481a_32.dll" (ByVal vi As Long, ByVal card As Integer, timerVal As Double) As Long

Declare Function age8481a_outpEcltStat_M Lib "age8481a_32.dll" (ByVal vi As Long, ByVal ecltNum As Integer, ByVal outpEcltStat As Integer) As Long

Declare Function age8481a_outpEcltStat_M_Q Lib "age8481a_32.dll" (ByVal vi As Long, ByVal ecltNum As Integer, outpEcltStat As Integer) As Long

Declare Function age8481a_outpStat Lib "age8481a_32.dll" (ByVal vi As Long, ByVal outpStat As Integer) As Long

Declare Function age8481a_outpStat_Q Lib "age8481a_32.dll" (ByVal vi As Long, outpStat As Integer) As Long

Declare Function age8481a_outpTtltStat_M Lib "age8481a_32.dll" (ByVal vi As Long, ByVal ttltNum As Integer, ByVal outpTtltStat As Integer) As Long

Declare Function age8481a_outpTtltStat_M_Q Lib "age8481a_32.dll" (ByVal vi As Long, ByVal ttltNum As Integer, outpTtltStat As Integer) As Long

Declare Function age8481a_routClos Lib "age8481a_32.dll" (ByVal vi As Long, ByVal channel As Long) As Long

Declare Function age8481a_routClos_Q Lib "age8481a_32.dll" (ByVal vi As Long, ByVal channel As Long, routClos As Integer) As Long

Declare Function age8481a_routClosList Lib "age8481a_32.dll" (ByVal vi As Long, ByVal channelList As String) As Long

Declare Function age8481a_routClosList_Q Lib "age8481a_32.dll" (ByVal vi As Long, ByVal channelList As String, ByVal routClosList As String) As Long

Declare Function age8481a_routFunc Lib "age8481a_32.dll" (ByVal vi As Long, ByVal card As Integer, mode As String) As Long

Declare Function age8481a_routFunc_Q Lib "age8481a_32.dll" (ByVal vi As Long, ByVal card As Integer, mode As String) As Long

Declare Function age8481a_routOpen Lib "age8481a_32.dll" (ByVal vi As Long, ByVal channel As Long) As Long

Declare Function age8481a_routOpen_Q Lib "age8481a_32.dll" (ByVal vi As Long, ByVal channel As Long, routOpen As Integer) As Long

Declare Function age8481a_routOpenList Lib "age8481a_32.dll" (ByVal vi As Long, ByVal channelList As String) As Long

Declare Function age8481a_routOpenList_Q Lib "age8481a_32.dll" (ByVal vi As Long, ByVal channelList As String, ByVal routOpenList As String) As Long

Declare Function age8481a_routPattActivate Lib "age8481a_32.dll" (ByVal vi As Long, ByVal card As Integer, ByVal pattern As Integer) As Long

Declare Function age8481a_routPattActivate_Q Lib "age8481a_32.dll" (ByVal vi As Long, ByVal card As Integer, pattern As Integer) As Long

Declare Function age8481a_routPattClosList Lib "age8481a_32.dll" (ByVal vi As Long, ByVal channelList As String) As Long

Declare Function age8481a_routPattClosList_Q Lib "age8481a_32.dll" (ByVal vi As Long, ByVal channelList As String, ByVal closeList As String) As Long

Declare Function age8481a_routPattern Lib "age8481a_32.dll" (ByVal vi As Long, ByVal card As Integer, ByVal pattern As Integer) As Long

Declare Function age8481a_routPattern_Q Lib "age8481a_32.dll" (ByVal vi As Long, ByVal card As Integer, pattern As Integer) As Long

Declare Function age8481a_routPattOpenList Lib "age8481a_32.dll" (ByVal vi As Long, ByVal channelList As String) As Long

Declare Function age8481a_routPattOpenList_Q Lib "age8481a_32.dll" (ByVal vi As Long, ByVal channelList As String, ByVal openList As String) As Long

Declare Function age8481a_routScanList Lib "age8481a_32.dll" (ByVal vi As Long, ByVal channelList As String) As Long

Declare Function age8481a_systCdes_Q Lib "age8481a_32.dll" (ByVal vi As Long, ByVal card As Integer, ByVal systCdes As String) As Long

Declare Function age8481a_systCpon Lib "age8481a_32.dll" (ByVal vi As Long, ByVal card As Integer) As Long

Declare Function age8481a_systCtyp_Q Lib "age8481a_32.dll" (ByVal vi As Long, ByVal card As Integer, ByVal systCtyp As String) As Long

Declare Function age8481a_trigImm Lib "age8481a_32.dll" (ByVal vi As Long) As Long

Declare Function age8481a_trigSour Lib "age8481a_32.dll" (ByVal vi As Long, ByVal trigSour As Integer) As Long

Declare Function age8481a_trigSour_Q Lib "age8481a_32.dll" (ByVal vi As Long, trigSour As Integer) As Long

